using System;
using System.Collections.Generic;

class Program
{
    static int Bfs(int start, Dictionary<int, List<int>> graph, Dictionary<int, bool> platforms, int[] jumps)
    {
        Queue<(int, int)> queue = new Queue<(int, int)>();
        HashSet<int> visited = new HashSet<int>();

        queue.Enqueue((start, 0));

        while (queue.Count > 0)
        {
            var (current, steps) = queue.Dequeue();

            if (platforms[current])
            {
                return steps; // Ako zec može odmah izaci
            }

            if (steps >= jumps[current - 1])
            {
                continue; // Zec ne može dalje skociti od svoje snage
            }

            foreach (var neighbor in graph[current])
            {
                if (!visited.Contains(neighbor))
                {
                    visited.Add(neighbor);
                    queue.Enqueue((neighbor, steps + 1));
                }
            }
        }

        return -1; // Zec je zaglavljen
    }

    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        var graph = new Dictionary<int, List<int>>();
        var platforms = new Dictionary<int, bool>();
        var jumps = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
        var changes = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

        for (int i = 1; i <= N; i++)
        {
            graph[i] = new List<int>();
            platforms[i] = changes[i - 1] == 1;
        }

        for (int i = 1; i < N; i++)
        {
            var input = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
            int u = input[0], v = input[1];
            graph[u].Add(v);
            graph[v].Add(u);
        }

        for (int i = 1; i <= N; i++)
        {
            int result = Bfs(i, graph, platforms, jumps);
            Console.Write(result + " ");
        }
    }
}